<?php

/**

 * Plugin Name: IIC Quotes

 * Plugin URI: https://insureincanada.codepixel.ca

 * Description: Plugin to show Super Visa and Visitors Insurance Quotes from IIC API.

 * Version: 2.41

 * Author: Harry Ghuman

 * Author URI: http://www.codepixel.ca

 */



// load update plugin script

//echo __DIR__ . DIRECTORY_SEPARATOR . 'plugin-update-checker' . DIRECTORY_SEPARATOR . 'plugin-update-checker.php';

require __DIR__ . DIRECTORY_SEPARATOR . 'plugin-update-checker' . DIRECTORY_SEPARATOR . 'plugin-update-checker.php';

$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(

    'https://updates.insureincanada.ca/details.json',

    __FILE__, //Full path to the main plugin file or functions.php.

    'iic-quotes'

);



function iic_quotes_func($atts) {

    $a = shortcode_atts(array(

        'hash' => ''

    ), $atts);



    return '

<div id="app">loading app.</div>
<script>!function(e){function r(r){for(var n,l,a=r[0],p=r[1],f=r[2],c=0,s=[];c<a.length;c++)l=a[c],Object.prototype.hasOwnProperty.call(o,l)&&o[l]&&s.push(o[l][0]),o[l]=0;for(n in p)Object.prototype.hasOwnProperty.call(p,n)&&(e[n]=p[n]);for(i&&i(r);s.length;)s.shift()();return u.push.apply(u,f||[]),t()}function t(){for(var e,r=0;r<u.length;r++){for(var t=u[r],n=!0,a=1;a<t.length;a++){var p=t[a];0!==o[p]&&(n=!1)}n&&(u.splice(r--,1),e=l(l.s=t[0]))}return e}var n={},o={1:0},u=[];function l(r){if(n[r])return n[r].exports;var t=n[r]={i:r,l:!1,exports:{}};return e[r].call(t.exports,t,t.exports,l),t.l=!0,t.exports}l.m=e,l.c=n,l.d=function(e,r,t){l.o(e,r)||Object.defineProperty(e,r,{enumerable:!0,get:t})},l.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},l.t=function(e,r){if(1&r&&(e=l(e)),8&r)return e;if(4&r&&"object"==typeof e&&e&&e.__esModule)return e;var t=Object.create(null);if(l.r(t),Object.defineProperty(t,"default",{enumerable:!0,value:e}),2&r&&"string"!=typeof e)for(var n in e)l.d(t,n,function(r){return e[r]}.bind(null,n));return t},l.n=function(e){var r=e&&e.__esModule?function(){return e.default}:function(){return e};return l.d(r,"a",r),r},l.o=function(e,r){return Object.prototype.hasOwnProperty.call(e,r)},l.p="/";var a=this["webpackJsonpweb-spa"]=this["webpackJsonpweb-spa"]||[],p=a.push.bind(a);a.push=r,a=a.slice();for(var f=0;f<a.length;f++)r(a[f]);var i=p;t()}([])</script>
';

}



add_shortcode('iicquotes', 'iic_quotes_func');


function iic2_quotes_func($atts) {
    $a = shortcode_atts(array(
            'id' => 'app',
            'insurance-type' => 'lifeInsurance',
            'form-path' => '/term-life-insurance',
            'quote-path' => '/term-life-insurance/quotes',
            'order-path' => '/order'
        ), $atts);

        return '<div id="' . $a['id'] . '" data-insurance-type="' . $a['insurance-type'] . '" data-form-path="' . $a['form-path'] . '" data-quote-path="' . $a['quote-path'] . '" data-order-path="' . $a['order-path'] . '">loading app.</div>
    <script>!function(e){function r(r){for(var n,l,a=r[0],p=r[1],f=r[2],c=0,s=[];c<a.length;c++)l=a[c],Object.prototype.hasOwnProperty.call(o,l)&&o[l]&&s.push(o[l][0]),o[l]=0;for(n in p)Object.prototype.hasOwnProperty.call(p,n)&&(e[n]=p[n]);for(i&&i(r);s.length;)s.shift()();return u.push.apply(u,f||[]),t()}function t(){for(var e,r=0;r<u.length;r++){for(var t=u[r],n=!0,a=1;a<t.length;a++){var p=t[a];0!==o[p]&&(n=!1)}n&&(u.splice(r--,1),e=l(l.s=t[0]))}return e}var n={},o={1:0},u=[];function l(r){if(n[r])return n[r].exports;var t=n[r]={i:r,l:!1,exports:{}};return e[r].call(t.exports,t,t.exports,l),t.l=!0,t.exports}l.m=e,l.c=n,l.d=function(e,r,t){l.o(e,r)||Object.defineProperty(e,r,{enumerable:!0,get:t})},l.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},l.t=function(e,r){if(1&r&&(e=l(e)),8&r)return e;if(4&r&&"object"==typeof e&&e&&e.__esModule)return e;var t=Object.create(null);if(l.r(t),Object.defineProperty(t,"default",{enumerable:!0,value:e}),2&r&&"string"!=typeof e)for(var n in e)l.d(t,n,function(r){return e[r]}.bind(null,n));return t},l.n=function(e){var r=e&&e.__esModule?function(){return e.default}:function(){return e};return l.d(r,"a",r),r},l.o=function(e,r){return Object.prototype.hasOwnProperty.call(e,r)},l.p="/";var a=this["webpackJsonpweb-spa"]=this["webpackJsonpweb-spa"]||[],p=a.push.bind(a);a.push=r,a=a.slice();for(var f=0;f<a.length;f++)r(a[f]);var i=p;t()}([])</script>
    ';
}

add_shortcode('iic2quotes', 'iic2_quotes_func');



add_action('wp_enqueue_scripts', 'iic_scripts');

function iic_scripts() {

    wp_register_script('iicScript1',

        plugin_dir_url( __FILE__ ) .'static/js/2.a864126b.chunk.js', array(), null, true

    );

    wp_register_script('iicScript2',

        plugin_dir_url( __FILE__ ) .'static/js/main.1357b222.chunk.js', array(), null, true

    );

    wp_enqueue_script('iicScript1');

    wp_enqueue_script('iicScript2');

    wp_enqueue_style( 'iic-css', plugin_dir_url( __FILE__ ) .'static/css/2.de5665f9.chunk.css' );
    wp_enqueue_style( 'iic-style-overwrite', plugin_dir_url( __FILE__ ) .'iic-styles.css' );

}
