<?php

/**

 * Plugin Name: IIC Quotes VA

 * Plugin URI: https://updates.insureincanada.ca

 * Description: Plugin to show Super Visa and Visitors Insurance Quotes from IIC API (VA Style).

 * Version: 2.44

 * Author: Harry Ghuman

 * Author URI: http://www.codepixel.ca

 */



// load update plugin script

//echo __DIR__ . DIRECTORY_SEPARATOR . 'plugin-update-checker' . DIRECTORY_SEPARATOR . 'plugin-update-checker.php';

require __DIR__ . DIRECTORY_SEPARATOR . 'plugin-update-checker' . DIRECTORY_SEPARATOR . 'plugin-update-checker.php';

$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(

    'https://updates.insureincanada.ca/details-va.json',

    __FILE__, //Full path to the main plugin file or functions.php.

    'iic-quotes-va'

);



function iic_quotes_func($atts) {
    $a = shortcode_atts(array(
        'hash' => ''
    ), $atts);

    return '<div id="app">loading app.</div>';
}

add_shortcode('iicquotes', 'iic_quotes_func');

function iic2_quotes_func($atts) {
    $a = shortcode_atts(array(
        'id' => 'app',
        'insurance-type' => 'lifeInsurance',
        'form-path' => '/term-life-insurance',
        'quote-path' => '/term-life-insurance/quotes',
        'order-path' => '/order'
    ), $atts);

    return '<div id="' . $a['id'] . '" data-insurance-type="' . $a['insurance-type'] . '" data-form-path="' . $a['form-path'] . '" data-quote-path="' . $a['quote-path'] . '" data-order-path="' . $a['order-path'] . '">loading app.</div>';
}

add_shortcode('iic2quotes', 'iic2_quotes_func');


add_action('wp_enqueue_scripts', 'iic_scripts');

function iic_scripts() {

    wp_register_script('iicScript1',

        plugin_dir_url( __FILE__ ) .'static/js/main.d6e709ec.js', array(), null, true

    );

    wp_enqueue_script('iicScript1');

    wp_enqueue_style( 'iic-plugin-styles', plugin_dir_url( __FILE__ ) .'static/css/main.de5665f9.css' );
    wp_enqueue_style( 'iic-style-overwrite', plugin_dir_url( __FILE__ ) .'iic-styles.css' );

}
